package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceGuardVirtualizationBasedSecurityHardwareRequirementState implements Enum {

    @JsonProperty("meetHardwareRequirements")
    MEET_HARDWARE_REQUIREMENTS("meetHardwareRequirements", "0"),

    @JsonProperty("secureBootRequired")
    SECURE_BOOT_REQUIRED("secureBootRequired", "1"),

    @JsonProperty("dmaProtectionRequired")
    DMA_PROTECTION_REQUIRED("dmaProtectionRequired", "2"),

    @JsonProperty("hyperVNotSupportedForGuestVM")
    HYPER_VNOT_SUPPORTED_FOR_GUEST_VM("hyperVNotSupportedForGuestVM", "4"),

    @JsonProperty("hyperVNotAvailable")
    HYPER_VNOT_AVAILABLE("hyperVNotAvailable", "8");

    private final String name;
    private final String value;

    private DeviceGuardVirtualizationBasedSecurityHardwareRequirementState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
