package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceEnrollmentType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("userEnrollment")
    USER_ENROLLMENT("userEnrollment", "1"),

    @JsonProperty("deviceEnrollmentManager")
    DEVICE_ENROLLMENT_MANAGER("deviceEnrollmentManager", "2"),

    @JsonProperty("appleBulkWithUser")
    APPLE_BULK_WITH_USER("appleBulkWithUser", "3"),

    @JsonProperty("appleBulkWithoutUser")
    APPLE_BULK_WITHOUT_USER("appleBulkWithoutUser", "4"),

    @JsonProperty("windowsAzureADJoin")
    WINDOWS_AZURE_ADJOIN("windowsAzureADJoin", "5"),

    @JsonProperty("windowsBulkUserless")
    WINDOWS_BULK_USERLESS("windowsBulkUserless", "6"),

    @JsonProperty("windowsAutoEnrollment")
    WINDOWS_AUTO_ENROLLMENT("windowsAutoEnrollment", "7"),

    @JsonProperty("windowsBulkAzureDomainJoin")
    WINDOWS_BULK_AZURE_DOMAIN_JOIN("windowsBulkAzureDomainJoin", "8"),

    @JsonProperty("windowsCoManagement")
    WINDOWS_CO_MANAGEMENT("windowsCoManagement", "9"),

    @JsonProperty("windowsAzureADJoinUsingDeviceAuth")
    WINDOWS_AZURE_ADJOIN_USING_DEVICE_AUTH("windowsAzureADJoinUsingDeviceAuth", "10"),

    @JsonProperty("appleUserEnrollment")
    APPLE_USER_ENROLLMENT("appleUserEnrollment", "11"),

    @JsonProperty("appleUserEnrollmentWithServiceAccount")
    APPLE_USER_ENROLLMENT_WITH_SERVICE_ACCOUNT("appleUserEnrollmentWithServiceAccount", "12"),

    @JsonProperty("azureAdJoinUsingAzureVmExtension")
    AZURE_AD_JOIN_USING_AZURE_VM_EXTENSION("azureAdJoinUsingAzureVmExtension", "14"),

    @JsonProperty("androidEnterpriseDedicatedDevice")
    ANDROID_ENTERPRISE_DEDICATED_DEVICE("androidEnterpriseDedicatedDevice", "15"),

    @JsonProperty("androidEnterpriseFullyManaged")
    ANDROID_ENTERPRISE_FULLY_MANAGED("androidEnterpriseFullyManaged", "16"),

    @JsonProperty("androidEnterpriseCorporateWorkProfile")
    ANDROID_ENTERPRISE_CORPORATE_WORK_PROFILE("androidEnterpriseCorporateWorkProfile", "17");

    private final String name;
    private final String value;

    private DeviceEnrollmentType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
