package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceEnrollmentConfigurationType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("limit")
    LIMIT("limit", "1"),

    @JsonProperty("platformRestrictions")
    PLATFORM_RESTRICTIONS("platformRestrictions", "2"),

    @JsonProperty("windowsHelloForBusiness")
    WINDOWS_HELLO_FOR_BUSINESS("windowsHelloForBusiness", "3"),

    @JsonProperty("defaultLimit")
    DEFAULT_LIMIT("defaultLimit", "4"),

    @JsonProperty("defaultPlatformRestrictions")
    DEFAULT_PLATFORM_RESTRICTIONS("defaultPlatformRestrictions", "5"),

    @JsonProperty("defaultWindowsHelloForBusiness")
    DEFAULT_WINDOWS_HELLO_FOR_BUSINESS("defaultWindowsHelloForBusiness", "6"),

    @JsonProperty("defaultWindows10EnrollmentCompletionPageConfiguration")
    DEFAULT_WINDOWS10ENROLLMENT_COMPLETION_PAGE_CONFIGURATION("defaultWindows10EnrollmentCompletionPageConfiguration", "7"),

    @JsonProperty("windows10EnrollmentCompletionPageConfiguration")
    WINDOWS10ENROLLMENT_COMPLETION_PAGE_CONFIGURATION("windows10EnrollmentCompletionPageConfiguration", "8"),

    @JsonProperty("deviceComanagementAuthorityConfiguration")
    DEVICE_COMANAGEMENT_AUTHORITY_CONFIGURATION("deviceComanagementAuthorityConfiguration", "9"),

    @JsonProperty("singlePlatformRestriction")
    SINGLE_PLATFORM_RESTRICTION("singlePlatformRestriction", "10"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "11");

    private final String name;
    private final String value;

    private DeviceEnrollmentConfigurationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
