package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceComplianceScriptRulOperator implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("and")
    AND("and", "1"),

    @JsonProperty("or")
    OR("or", "2"),

    @JsonProperty("isEquals")
    IS_EQUALS("isEquals", "3"),

    @JsonProperty("notEquals")
    NOT_EQUALS("notEquals", "4"),

    @JsonProperty("greaterThan")
    GREATER_THAN("greaterThan", "5"),

    @JsonProperty("lessThan")
    LESS_THAN("lessThan", "6"),

    @JsonProperty("between")
    BETWEEN("between", "7"),

    @JsonProperty("notBetween")
    NOT_BETWEEN("notBetween", "8"),

    @JsonProperty("greaterEquals")
    GREATER_EQUALS("greaterEquals", "9"),

    @JsonProperty("lessEquals")
    LESS_EQUALS("lessEquals", "10"),

    @JsonProperty("dayTimeBetween")
    DAY_TIME_BETWEEN("dayTimeBetween", "11"),

    @JsonProperty("beginsWith")
    BEGINS_WITH("beginsWith", "12"),

    @JsonProperty("notBeginsWith")
    NOT_BEGINS_WITH("notBeginsWith", "13"),

    @JsonProperty("endsWith")
    ENDS_WITH("endsWith", "14"),

    @JsonProperty("notEndsWith")
    NOT_ENDS_WITH("notEndsWith", "15"),

    @JsonProperty("contains")
    CONTAINS("contains", "16"),

    @JsonProperty("notContains")
    NOT_CONTAINS("notContains", "17"),

    @JsonProperty("allOf")
    ALL_OF("allOf", "18"),

    @JsonProperty("oneOf")
    ONE_OF("oneOf", "19"),

    @JsonProperty("noneOf")
    NONE_OF("noneOf", "20"),

    @JsonProperty("setEquals")
    SET_EQUALS("setEquals", "21"),

    @JsonProperty("orderedSetEquals")
    ORDERED_SET_EQUALS("orderedSetEquals", "22"),

    @JsonProperty("subsetOf")
    SUBSET_OF("subsetOf", "23"),

    @JsonProperty("excludesAll")
    EXCLUDES_ALL("excludesAll", "24");

    private final String name;
    private final String value;

    private DeviceComplianceScriptRulOperator(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
