package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DelegatedAdminRelationshipStatus implements Enum {

    @JsonProperty("activating")
    ACTIVATING("activating", "0"),

    @JsonProperty("active")
    ACTIVE("active", "1"),

    @JsonProperty("approvalPending")
    APPROVAL_PENDING("approvalPending", "2"),

    @JsonProperty("approved")
    APPROVED("approved", "3"),

    @JsonProperty("created")
    CREATED("created", "4"),

    @JsonProperty("expired")
    EXPIRED("expired", "5"),

    @JsonProperty("expiring")
    EXPIRING("expiring", "6"),

    @JsonProperty("terminated")
    TERMINATED("terminated", "7"),

    @JsonProperty("terminating")
    TERMINATING("terminating", "8"),

    @JsonProperty("terminationRequested")
    TERMINATION_REQUESTED("terminationRequested", "9"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "10");

    private final String name;
    private final String value;

    private DelegatedAdminRelationshipStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
