package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DelegatedAdminAccessAssignmentStatus implements Enum {

    @JsonProperty("pending")
    PENDING("pending", "0"),

    @JsonProperty("active")
    ACTIVE("active", "1"),

    @JsonProperty("deleting")
    DELETING("deleting", "2"),

    @JsonProperty("deleted")
    DELETED("deleted", "3"),

    @JsonProperty("error")
    ERROR("error", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private DelegatedAdminAccessAssignmentStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
