package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DefenderThreatAction implements Enum {

    @JsonProperty("deviceDefault")
    DEVICE_DEFAULT("deviceDefault", "0"),

    @JsonProperty("clean")
    CLEAN("clean", "1"),

    @JsonProperty("quarantine")
    QUARANTINE("quarantine", "2"),

    @JsonProperty("remove")
    REMOVE("remove", "3"),

    @JsonProperty("allow")
    ALLOW("allow", "4"),

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "5"),

    @JsonProperty("block")
    BLOCK("block", "6");

    private final String name;
    private final String value;

    private DefenderThreatAction(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
