package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DefenderCloudBlockLevelType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("high")
    HIGH("high", "1"),

    @JsonProperty("highPlus")
    HIGH_PLUS("highPlus", "2"),

    @JsonProperty("zeroTolerance")
    ZERO_TOLERANCE("zeroTolerance", "3");

    private final String name;
    private final String value;

    private DefenderCloudBlockLevelType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
