package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ConnectionOperationStatus implements Enum {

    @JsonProperty("unspecified")
    UNSPECIFIED("unspecified", "0"),

    @JsonProperty("inprogress")
    INPROGRESS("inprogress", "1"),

    @JsonProperty("completed")
    COMPLETED("completed", "2"),

    @JsonProperty("failed")
    FAILED("failed", "3");

    private final String name;
    private final String value;

    private ConnectionOperationStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
