package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ConfigurationManagerClientState implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("installed")
    INSTALLED("installed", "1"),

    @JsonProperty("healthy")
    HEALTHY("healthy", "7"),

    @JsonProperty("installFailed")
    INSTALL_FAILED("installFailed", "8"),

    @JsonProperty("updateFailed")
    UPDATE_FAILED("updateFailed", "11"),

    @JsonProperty("communicationError")
    COMMUNICATION_ERROR("communicationError", "19");

    private final String name;
    private final String value;

    private ConfigurationManagerClientState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
