package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ConfigurationManagerActionDeliveryStatus implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("pendingDelivery")
    PENDING_DELIVERY("pendingDelivery", "1"),

    @JsonProperty("deliveredToConnectorService")
    DELIVERED_TO_CONNECTOR_SERVICE("deliveredToConnectorService", "2"),

    @JsonProperty("failedToDeliverToConnectorService")
    FAILED_TO_DELIVER_TO_CONNECTOR_SERVICE("failedToDeliverToConnectorService", "3"),

    @JsonProperty("deliveredToOnPremisesServer")
    DELIVERED_TO_ON_PREMISES_SERVER("deliveredToOnPremisesServer", "4");

    private final String name;
    private final String value;

    private ConfigurationManagerActionDeliveryStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
