package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ConditionalAccessRule implements Enum {

    @JsonProperty("allApps")
    ALL_APPS("allApps", "0"),

    @JsonProperty("firstPartyApps")
    FIRST_PARTY_APPS("firstPartyApps", "1"),

    @JsonProperty("office365")
    OFFICE365("office365", "2"),

    @JsonProperty("appId")
    APP_ID("appId", "3"),

    @JsonProperty("acr")
    ACR("acr", "4"),

    @JsonProperty("appFilter")
    APP_FILTER("appFilter", "5"),

    @JsonProperty("allUsers")
    ALL_USERS("allUsers", "6"),

    @JsonProperty("guest")
    GUEST("guest", "7"),

    @JsonProperty("groupId")
    GROUP_ID("groupId", "8"),

    @JsonProperty("roleId")
    ROLE_ID("roleId", "9"),

    @JsonProperty("userId")
    USER_ID("userId", "10"),

    @JsonProperty("allDevicePlatforms")
    ALL_DEVICE_PLATFORMS("allDevicePlatforms", "11"),

    @JsonProperty("devicePlatform")
    DEVICE_PLATFORM("devicePlatform", "12"),

    @JsonProperty("allLocations")
    ALL_LOCATIONS("allLocations", "13"),

    @JsonProperty("insideCorpnet")
    INSIDE_CORPNET("insideCorpnet", "14"),

    @JsonProperty("allTrustedLocations")
    ALL_TRUSTED_LOCATIONS("allTrustedLocations", "15"),

    @JsonProperty("locationId")
    LOCATION_ID("locationId", "16"),

    @JsonProperty("allDevices")
    ALL_DEVICES("allDevices", "17"),

    @JsonProperty("deviceFilter")
    DEVICE_FILTER("deviceFilter", "18"),

    @JsonProperty("deviceState")
    DEVICE_STATE("deviceState", "19"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "20"),

    @JsonProperty("deviceFilterIncludeRuleNotMatched")
    DEVICE_FILTER_INCLUDE_RULE_NOT_MATCHED("deviceFilterIncludeRuleNotMatched", "21"),

    @JsonProperty("allDeviceStates")
    ALL_DEVICE_STATES("allDeviceStates", "22");

    private final String name;
    private final String value;

    private ConditionalAccessRule(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
