package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ConditionalAccessConditions implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("application")
    APPLICATION("application", "1"),

    @JsonProperty("users")
    USERS("users", "2"),

    @JsonProperty("devicePlatform")
    DEVICE_PLATFORM("devicePlatform", "4"),

    @JsonProperty("location")
    LOCATION("location", "8"),

    @JsonProperty("clientType")
    CLIENT_TYPE("clientType", "16"),

    @JsonProperty("signInRisk")
    SIGN_IN_RISK("signInRisk", "32"),

    @JsonProperty("userRisk")
    USER_RISK("userRisk", "64"),

    @JsonProperty("time")
    TIME("time", "128"),

    @JsonProperty("deviceState")
    DEVICE_STATE("deviceState", "256"),

    @JsonProperty("client")
    CLIENT("client", "512"),

    @JsonProperty("ipAddressSeenByAzureAD")
    IP_ADDRESS_SEEN_BY_AZURE_AD("ipAddressSeenByAzureAD", "1024"),

    @JsonProperty("ipAddressSeenByResourceProvider")
    IP_ADDRESS_SEEN_BY_RESOURCE_PROVIDER("ipAddressSeenByResourceProvider", "2048"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4096"),

    @JsonProperty("servicePrincipals")
    SERVICE_PRINCIPALS("servicePrincipals", "8192"),

    @JsonProperty("servicePrincipalRisk")
    SERVICE_PRINCIPAL_RISK("servicePrincipalRisk", "16384");

    private final String name;
    private final String value;

    private ConditionalAccessConditions(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
