package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ColumnTypes implements Enum {

    @JsonProperty("note")
    NOTE("note", "0"),

    @JsonProperty("text")
    TEXT("text", "1"),

    @JsonProperty("choice")
    CHOICE("choice", "2"),

    @JsonProperty("multichoice")
    MULTICHOICE("multichoice", "3"),

    @JsonProperty("number")
    NUMBER("number", "4"),

    @JsonProperty("currency")
    CURRENCY("currency", "5"),

    @JsonProperty("dateTime")
    DATE_TIME("dateTime", "6"),

    @JsonProperty("lookup")
    LOOKUP("lookup", "7"),

    @JsonProperty("boolean")
    BOOLEAN("boolean", "8"),

    @JsonProperty("user")
    USER("user", "9"),

    @JsonProperty("url")
    URL("url", "10"),

    @JsonProperty("calculated")
    CALCULATED("calculated", "11"),

    @JsonProperty("location")
    LOCATION("location", "12"),

    @JsonProperty("geolocation")
    GEOLOCATION("geolocation", "13"),

    @JsonProperty("term")
    TERM("term", "14"),

    @JsonProperty("multiterm")
    MULTITERM("multiterm", "15"),

    @JsonProperty("thumbnail")
    THUMBNAIL("thumbnail", "16"),

    @JsonProperty("approvalStatus")
    APPROVAL_STATUS("approvalStatus", "17"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "18");

    private final String name;
    private final String value;

    private ColumnTypes(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
