package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CloudPcOnPremisesConnectionStatus implements Enum {

    @JsonProperty("pending")
    PENDING("pending", "0"),

    @JsonProperty("running")
    RUNNING("running", "10"),

    @JsonProperty("passed")
    PASSED("passed", "20"),

    @JsonProperty("failed")
    FAILED("failed", "30"),

    @JsonProperty("warning")
    WARNING("warning", "40"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "999");

    private final String name;
    private final String value;

    private CloudPcOnPremisesConnectionStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
