package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CloudPcOnPremisesConnectionHealthCheckErrorType implements Enum {

    @JsonProperty("dnsCheckFqdnNotFound")
    DNS_CHECK_FQDN_NOT_FOUND("dnsCheckFqdnNotFound", "100"),

    @JsonProperty("dnsCheckNameWithInvalidCharacter")
    DNS_CHECK_NAME_WITH_INVALID_CHARACTER("dnsCheckNameWithInvalidCharacter", "101"),

    @JsonProperty("dnsCheckUnknownError")
    DNS_CHECK_UNKNOWN_ERROR("dnsCheckUnknownError", "199"),

    @JsonProperty("adJoinCheckFqdnNotFound")
    AD_JOIN_CHECK_FQDN_NOT_FOUND("adJoinCheckFqdnNotFound", "200"),

    @JsonProperty("adJoinCheckIncorrectCredentials")
    AD_JOIN_CHECK_INCORRECT_CREDENTIALS("adJoinCheckIncorrectCredentials", "201"),

    @JsonProperty("adJoinCheckOrganizationalUnitNotFound")
    AD_JOIN_CHECK_ORGANIZATIONAL_UNIT_NOT_FOUND("adJoinCheckOrganizationalUnitNotFound", "202"),

    @JsonProperty("adJoinCheckOrganizationalUnitIncorrectFormat")
    AD_JOIN_CHECK_ORGANIZATIONAL_UNIT_INCORRECT_FORMAT("adJoinCheckOrganizationalUnitIncorrectFormat", "203"),

    @JsonProperty("adJoinCheckComputerObjectAlreadyExists")
    AD_JOIN_CHECK_COMPUTER_OBJECT_ALREADY_EXISTS("adJoinCheckComputerObjectAlreadyExists", "204"),

    @JsonProperty("adJoinCheckAccessDenied")
    AD_JOIN_CHECK_ACCESS_DENIED("adJoinCheckAccessDenied", "205"),

    @JsonProperty("adJoinCheckCredentialsExpired")
    AD_JOIN_CHECK_CREDENTIALS_EXPIRED("adJoinCheckCredentialsExpired", "206"),

    @JsonProperty("adJoinCheckAccountLockedOrDisabled")
    AD_JOIN_CHECK_ACCOUNT_LOCKED_OR_DISABLED("adJoinCheckAccountLockedOrDisabled", "207"),

    @JsonProperty("adJoinCheckAccountQuotaExceeded")
    AD_JOIN_CHECK_ACCOUNT_QUOTA_EXCEEDED("adJoinCheckAccountQuotaExceeded", "208"),

    @JsonProperty("adJoinCheckUnknownError")
    AD_JOIN_CHECK_UNKNOWN_ERROR("adJoinCheckUnknownError", "299"),

    @JsonProperty("endpointConnectivityCheckCloudPcUrlNotAllowListed")
    ENDPOINT_CONNECTIVITY_CHECK_CLOUD_PC_URL_NOT_ALLOW_LISTED("endpointConnectivityCheckCloudPcUrlNotAllowListed", "300"),

    @JsonProperty("endpointConnectivityCheckWVDUrlNotAllowListed")
    ENDPOINT_CONNECTIVITY_CHECK_WVDURL_NOT_ALLOW_LISTED("endpointConnectivityCheckWVDUrlNotAllowListed", "301"),

    @JsonProperty("endpointConnectivityCheckIntuneUrlNotAllowListed")
    ENDPOINT_CONNECTIVITY_CHECK_INTUNE_URL_NOT_ALLOW_LISTED("endpointConnectivityCheckIntuneUrlNotAllowListed", "302"),

    @JsonProperty("endpointConnectivityCheckUnknownError")
    ENDPOINT_CONNECTIVITY_CHECK_UNKNOWN_ERROR("endpointConnectivityCheckUnknownError", "399"),

    @JsonProperty("azureAdDeviceSyncCheckDeviceNotFound")
    AZURE_AD_DEVICE_SYNC_CHECK_DEVICE_NOT_FOUND("azureAdDeviceSyncCheckDeviceNotFound", "400"),

    @JsonProperty("azureAdDeviceSyncCheckLongSyncCircle")
    AZURE_AD_DEVICE_SYNC_CHECK_LONG_SYNC_CIRCLE("azureAdDeviceSyncCheckLongSyncCircle", "401"),

    @JsonProperty("azureAdDeviceSyncCheckConnectDisabled")
    AZURE_AD_DEVICE_SYNC_CHECK_CONNECT_DISABLED("azureAdDeviceSyncCheckConnectDisabled", "402"),

    @JsonProperty("azureAdDeviceSyncCheckDurationExceeded")
    AZURE_AD_DEVICE_SYNC_CHECK_DURATION_EXCEEDED("azureAdDeviceSyncCheckDurationExceeded", "403"),

    @JsonProperty("azureAdDeviceSyncCheckScpNotConfigured")
    AZURE_AD_DEVICE_SYNC_CHECK_SCP_NOT_CONFIGURED("azureAdDeviceSyncCheckScpNotConfigured", "404"),

    @JsonProperty("azureAdDeviceSyncCheckTransientServiceError")
    AZURE_AD_DEVICE_SYNC_CHECK_TRANSIENT_SERVICE_ERROR("azureAdDeviceSyncCheckTransientServiceError", "498"),

    @JsonProperty("azureAdDeviceSyncCheckUnknownError")
    AZURE_AD_DEVICE_SYNC_CHECK_UNKNOWN_ERROR("azureAdDeviceSyncCheckUnknownError", "499"),

    @JsonProperty("resourceAvailabilityCheckNoSubnetIP")
    RESOURCE_AVAILABILITY_CHECK_NO_SUBNET_IP("resourceAvailabilityCheckNoSubnetIP", "500"),

    @JsonProperty("resourceAvailabilityCheckSubscriptionDisabled")
    RESOURCE_AVAILABILITY_CHECK_SUBSCRIPTION_DISABLED("resourceAvailabilityCheckSubscriptionDisabled", "501"),

    @JsonProperty("resourceAvailabilityCheckAzurePolicyViolation")
    RESOURCE_AVAILABILITY_CHECK_AZURE_POLICY_VIOLATION("resourceAvailabilityCheckAzurePolicyViolation", "502"),

    @JsonProperty("resourceAvailabilityCheckSubscriptionNotFound")
    RESOURCE_AVAILABILITY_CHECK_SUBSCRIPTION_NOT_FOUND("resourceAvailabilityCheckSubscriptionNotFound", "503"),

    @JsonProperty("resourceAvailabilityCheckSubscriptionTransferred")
    RESOURCE_AVAILABILITY_CHECK_SUBSCRIPTION_TRANSFERRED("resourceAvailabilityCheckSubscriptionTransferred", "504"),

    @JsonProperty("resourceAvailabilityCheckGeneralSubscriptionError")
    RESOURCE_AVAILABILITY_CHECK_GENERAL_SUBSCRIPTION_ERROR("resourceAvailabilityCheckGeneralSubscriptionError", "505"),

    @JsonProperty("resourceAvailabilityCheckUnsupportedVNetRegion")
    RESOURCE_AVAILABILITY_CHECK_UNSUPPORTED_VNET_REGION("resourceAvailabilityCheckUnsupportedVNetRegion", "506"),

    @JsonProperty("resourceAvailabilityCheckResourceGroupInvalid")
    RESOURCE_AVAILABILITY_CHECK_RESOURCE_GROUP_INVALID("resourceAvailabilityCheckResourceGroupInvalid", "507"),

    @JsonProperty("resourceAvailabilityCheckVNetInvalid")
    RESOURCE_AVAILABILITY_CHECK_VNET_INVALID("resourceAvailabilityCheckVNetInvalid", "508"),

    @JsonProperty("resourceAvailabilityCheckSubnetInvalid")
    RESOURCE_AVAILABILITY_CHECK_SUBNET_INVALID("resourceAvailabilityCheckSubnetInvalid", "509"),

    @JsonProperty("resourceAvailabilityCheckResourceGroupBeingDeleted")
    RESOURCE_AVAILABILITY_CHECK_RESOURCE_GROUP_BEING_DELETED("resourceAvailabilityCheckResourceGroupBeingDeleted", "510"),

    @JsonProperty("resourceAvailabilityCheckVNetBeingMoved")
    RESOURCE_AVAILABILITY_CHECK_VNET_BEING_MOVED("resourceAvailabilityCheckVNetBeingMoved", "511"),

    @JsonProperty("resourceAvailabilityCheckSubnetDelegationFailed")
    RESOURCE_AVAILABILITY_CHECK_SUBNET_DELEGATION_FAILED("resourceAvailabilityCheckSubnetDelegationFailed", "512"),

    @JsonProperty("resourceAvailabilityCheckSubnetWithExternalResources")
    RESOURCE_AVAILABILITY_CHECK_SUBNET_WITH_EXTERNAL_RESOURCES("resourceAvailabilityCheckSubnetWithExternalResources", "513"),

    @JsonProperty("resourceAvailabilityCheckResourceGroupLockedForReadonly")
    RESOURCE_AVAILABILITY_CHECK_RESOURCE_GROUP_LOCKED_FOR_READONLY("resourceAvailabilityCheckResourceGroupLockedForReadonly", "514"),

    @JsonProperty("resourceAvailabilityCheckResourceGroupLockedForDelete")
    RESOURCE_AVAILABILITY_CHECK_RESOURCE_GROUP_LOCKED_FOR_DELETE("resourceAvailabilityCheckResourceGroupLockedForDelete", "515"),

    @JsonProperty("resourceAvailabilityCheckTransientServiceError")
    RESOURCE_AVAILABILITY_CHECK_TRANSIENT_SERVICE_ERROR("resourceAvailabilityCheckTransientServiceError", "598"),

    @JsonProperty("resourceAvailabilityCheckUnknownError")
    RESOURCE_AVAILABILITY_CHECK_UNKNOWN_ERROR("resourceAvailabilityCheckUnknownError", "599"),

    @JsonProperty("permissionCheckNoSubscriptionReaderRole")
    PERMISSION_CHECK_NO_SUBSCRIPTION_READER_ROLE("permissionCheckNoSubscriptionReaderRole", "600"),

    @JsonProperty("permissionCheckNoResourceGroupOwnerRole")
    PERMISSION_CHECK_NO_RESOURCE_GROUP_OWNER_ROLE("permissionCheckNoResourceGroupOwnerRole", "601"),

    @JsonProperty("permissionCheckNoVNetContributorRole")
    PERMISSION_CHECK_NO_VNET_CONTRIBUTOR_ROLE("permissionCheckNoVNetContributorRole", "602"),

    @JsonProperty("permissionCheckNoResourceGroupNetworkContributorRole")
    PERMISSION_CHECK_NO_RESOURCE_GROUP_NETWORK_CONTRIBUTOR_ROLE("permissionCheckNoResourceGroupNetworkContributorRole", "603"),

    @JsonProperty("permissionCheckTransientServiceError")
    PERMISSION_CHECK_TRANSIENT_SERVICE_ERROR("permissionCheckTransientServiceError", "698"),

    @JsonProperty("permissionCheckUnknownError")
    PERMISSION_CHECK_UNKNOWN_ERROR("permissionCheckUnknownError", "699"),

    @JsonProperty("internalServerErrorDeploymentCanceled")
    INTERNAL_SERVER_ERROR_DEPLOYMENT_CANCELED("internalServerErrorDeploymentCanceled", "900"),

    @JsonProperty("internalServerErrorAllocateResourceFailed")
    INTERNAL_SERVER_ERROR_ALLOCATE_RESOURCE_FAILED("internalServerErrorAllocateResourceFailed", "901"),

    @JsonProperty("internalServerErrorVMDeploymentTimeout")
    INTERNAL_SERVER_ERROR_VMDEPLOYMENT_TIMEOUT("internalServerErrorVMDeploymentTimeout", "902"),

    @JsonProperty("internalServerErrorUnableToRunDscScript")
    INTERNAL_SERVER_ERROR_UNABLE_TO_RUN_DSC_SCRIPT("internalServerErrorUnableToRunDscScript", "903"),

    @JsonProperty("internalServerUnknownError")
    INTERNAL_SERVER_UNKNOWN_ERROR("internalServerUnknownError", "999"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "9999");

    private final String name;
    private final String value;

    private CloudPcOnPremisesConnectionHealthCheckErrorType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
