package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CloudPcDeviceImageStatusDetails implements Enum {

    @JsonProperty("internalServerError")
    INTERNAL_SERVER_ERROR("internalServerError", "0"),

    @JsonProperty("sourceImageNotFound")
    SOURCE_IMAGE_NOT_FOUND("sourceImageNotFound", "1"),

    @JsonProperty("osVersionNotSupported")
    OS_VERSION_NOT_SUPPORTED("osVersionNotSupported", "2"),

    @JsonProperty("sourceImageInvalid")
    SOURCE_IMAGE_INVALID("sourceImageInvalid", "3"),

    @JsonProperty("sourceImageNotGeneralized")
    SOURCE_IMAGE_NOT_GENERALIZED("sourceImageNotGeneralized", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "999");

    private final String name;
    private final String value;

    private CloudPcDeviceImageStatusDetails(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
