package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CloudPcAuditActivityOperationType implements Enum {

    @JsonProperty("create")
    CREATE("create", "0"),

    @JsonProperty("delete")
    DELETE("delete", "1"),

    @JsonProperty("patch")
    PATCH("patch", "2"),

    @JsonProperty("other")
    OTHER("other", "999");

    private final String name;
    private final String value;

    private CloudPcAuditActivityOperationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
