package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CloudAppSecuritySessionControlType implements Enum {

    @JsonProperty("mcasConfigured")
    MCAS_CONFIGURED("mcasConfigured", "0"),

    @JsonProperty("monitorOnly")
    MONITOR_ONLY("monitorOnly", "1"),

    @JsonProperty("blockDownloads")
    BLOCK_DOWNLOADS("blockDownloads", "2"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3");

    private final String name;
    private final String value;

    private CloudAppSecuritySessionControlType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
