package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ClonableTeamParts implements Enum {

    @JsonProperty("apps")
    APPS("apps", "1"),

    @JsonProperty("tabs")
    TABS("tabs", "2"),

    @JsonProperty("settings")
    SETTINGS("settings", "4"),

    @JsonProperty("channels")
    CHANNELS("channels", "8"),

    @JsonProperty("members")
    MEMBERS("members", "16");

    private final String name;
    private final String value;

    private ClonableTeamParts(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
