package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ClassificationMethod implements Enum {

    @JsonProperty("patternMatch")
    PATTERN_MATCH("patternMatch", "0"),

    @JsonProperty("exactDataMatch")
    EXACT_DATA_MATCH("exactDataMatch", "1"),

    @JsonProperty("fingerprint")
    FINGERPRINT("fingerprint", "2"),

    @JsonProperty("machineLearning")
    MACHINE_LEARNING("machineLearning", "3");

    private final String name;
    private final String value;

    private ClassificationMethod(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
