package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ChatMessageType implements Enum {

    @JsonProperty("message")
    MESSAGE("message", "0"),

    @JsonProperty("chatEvent")
    CHAT_EVENT("chatEvent", "1"),

    @JsonProperty("typing")
    TYPING("typing", "2"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3"),

    @JsonProperty("systemEventMessage")
    SYSTEM_EVENT_MESSAGE("systemEventMessage", "4");

    private final String name;
    private final String value;

    private ChatMessageType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
