package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ChassisType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("desktop")
    DESKTOP("desktop", "1"),

    @JsonProperty("laptop")
    LAPTOP("laptop", "2"),

    @JsonProperty("worksWorkstation")
    WORKS_WORKSTATION("worksWorkstation", "3"),

    @JsonProperty("enterpriseServer")
    ENTERPRISE_SERVER("enterpriseServer", "4"),

    @JsonProperty("phone")
    PHONE("phone", "100"),

    @JsonProperty("tablet")
    TABLET("tablet", "101"),

    @JsonProperty("mobileOther")
    MOBILE_OTHER("mobileOther", "102"),

    @JsonProperty("mobileUnknown")
    MOBILE_UNKNOWN("mobileUnknown", "103");

    private final String name;
    private final String value;

    private ChassisType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
