package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CertificateValidityPeriodScale implements Enum {

    @JsonProperty("days")
    DAYS("days", "0"),

    @JsonProperty("months")
    MONTHS("months", "1"),

    @JsonProperty("years")
    YEARS("years", "2");

    private final String name;
    private final String value;

    private CertificateValidityPeriodScale(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
