package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CertificateRevocationStatus implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("pending")
    PENDING("pending", "1"),

    @JsonProperty("issued")
    ISSUED("issued", "2"),

    @JsonProperty("failed")
    FAILED("failed", "3"),

    @JsonProperty("revoked")
    REVOKED("revoked", "4");

    private final String name;
    private final String value;

    private CertificateRevocationStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
