package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum BrowserSyncSetting implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("blockedWithUserOverride")
    BLOCKED_WITH_USER_OVERRIDE("blockedWithUserOverride", "1"),

    @JsonProperty("blocked")
    BLOCKED("blocked", "2");

    private final String name;
    private final String value;

    private BrowserSyncSetting(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
