package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum BodyType implements Enum {

    @JsonProperty("text")
    TEXT("text", "0"),

    @JsonProperty("html")
    HTML("html", "1");

    private final String name;
    private final String value;

    private BodyType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
