package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum BitLockerRecoveryInformationType implements Enum {

    @JsonProperty("passwordAndKey")
    PASSWORD_AND_KEY("passwordAndKey", "1"),

    @JsonProperty("passwordOnly")
    PASSWORD_ONLY("passwordOnly", "2");

    private final String name;
    private final String value;

    private BitLockerRecoveryInformationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
