package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AuthenticationTransformConstant implements Enum {

    @JsonProperty("md5_96")
    MD5_96("md5_96", "0"),

    @JsonProperty("sha1_96")
    SHA1_96("sha1_96", "1"),

    @JsonProperty("sha_256_128")
    SHA_256_128("sha_256_128", "2"),

    @JsonProperty("aes128Gcm")
    AES128GCM("aes128Gcm", "3"),

    @JsonProperty("aes192Gcm")
    AES192GCM("aes192Gcm", "4"),

    @JsonProperty("aes256Gcm")
    AES256GCM("aes256Gcm", "5");

    private final String name;
    private final String value;

    private AuthenticationTransformConstant(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
