package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AuthenticationMethodKeyStrength implements Enum {

    @JsonProperty("normal")
    NORMAL("normal", "0"),

    @JsonProperty("weak")
    WEAK("weak", "1"),

    @JsonProperty("unknown")
    UNKNOWN("unknown", "2");

    private final String name;
    private final String value;

    private AuthenticationMethodKeyStrength(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
