package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AuthenticationContextDetail implements Enum {

    @JsonProperty("required")
    REQUIRED("required", "0"),

    @JsonProperty("previouslySatisfied")
    PREVIOUSLY_SATISFIED("previouslySatisfied", "1"),

    @JsonProperty("notApplicable")
    NOT_APPLICABLE("notApplicable", "2"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3");

    private final String name;
    private final String value;

    private AuthenticationContextDetail(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
