package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AssignmentFilterPayloadType implements Enum {

    @JsonProperty("notSet")
    NOT_SET("notSet", "0"),

    @JsonProperty("enrollmentRestrictions")
    ENROLLMENT_RESTRICTIONS("enrollmentRestrictions", "1");

    private final String name;
    private final String value;

    private AssignmentFilterPayloadType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
