package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AssignmentFilterOperator implements Enum {

    @JsonProperty("notSet")
    NOT_SET("notSet", "0"),

    @JsonProperty("equals")
    EQUALS("equals", "1"),

    @JsonProperty("notEquals")
    NOT_EQUALS("notEquals", "2"),

    @JsonProperty("startsWith")
    STARTS_WITH("startsWith", "3"),

    @JsonProperty("notStartsWith")
    NOT_STARTS_WITH("notStartsWith", "4"),

    @JsonProperty("contains")
    CONTAINS("contains", "5"),

    @JsonProperty("notContains")
    NOT_CONTAINS("notContains", "6"),

    @JsonProperty("in")
    IN("in", "7"),

    @JsonProperty("notIn")
    NOT_IN("notIn", "8"),

    @JsonProperty("endsWith")
    ENDS_WITH("endsWith", "9"),

    @JsonProperty("notEndsWith")
    NOT_ENDS_WITH("notEndsWith", "10");

    private final String name;
    private final String value;

    private AssignmentFilterOperator(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
