package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ApplicationPermissionsRequired implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("anonymous")
    ANONYMOUS("anonymous", "1"),

    @JsonProperty("guest")
    GUEST("guest", "2"),

    @JsonProperty("user")
    USER("user", "3"),

    @JsonProperty("administrator")
    ADMINISTRATOR("administrator", "4"),

    @JsonProperty("system")
    SYSTEM("system", "5"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "127");

    private final String name;
    private final String value;

    private ApplicationPermissionsRequired(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
