package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ApplicationGuardEnabledOptions implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("enabledForEdge")
    ENABLED_FOR_EDGE("enabledForEdge", "1"),

    @JsonProperty("enabledForOffice")
    ENABLED_FOR_OFFICE("enabledForOffice", "2"),

    @JsonProperty("enabledForEdgeAndOffice")
    ENABLED_FOR_EDGE_AND_OFFICE("enabledForEdgeAndOffice", "3");

    private final String name;
    private final String value;

    private ApplicationGuardEnabledOptions(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
