package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AppVulnerabilityTaskMitigationType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("update")
    UPDATE("update", "1"),

    @JsonProperty("uninstall")
    UNINSTALL("uninstall", "2"),

    @JsonProperty("securityConfiguration")
    SECURITY_CONFIGURATION("securityConfiguration", "3");

    private final String name;
    private final String value;

    private AppVulnerabilityTaskMitigationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
