package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AppCredentialRestrictionType implements Enum {

    @JsonProperty("passwordAddition")
    PASSWORD_ADDITION("passwordAddition", "0"),

    @JsonProperty("passwordLifetime")
    PASSWORD_LIFETIME("passwordLifetime", "1"),

    @JsonProperty("symmetricKeyAddition")
    SYMMETRIC_KEY_ADDITION("symmetricKeyAddition", "2"),

    @JsonProperty("symmetricKeyLifetime")
    SYMMETRIC_KEY_LIFETIME("symmetricKeyLifetime", "3"),

    @JsonProperty("customPasswordAddition")
    CUSTOM_PASSWORD_ADDITION("customPasswordAddition", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "99");

    private final String name;
    private final String value;

    private AppCredentialRestrictionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
