package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidWorkProfileCrossProfileDataSharingType implements Enum {

    @JsonProperty("deviceDefault")
    DEVICE_DEFAULT("deviceDefault", "0"),

    @JsonProperty("preventAny")
    PREVENT_ANY("preventAny", "1"),

    @JsonProperty("allowPersonalToWork")
    ALLOW_PERSONAL_TO_WORK("allowPersonalToWork", "2"),

    @JsonProperty("noRestrictions")
    NO_RESTRICTIONS("noRestrictions", "3");

    private final String name;
    private final String value;

    private AndroidWorkProfileCrossProfileDataSharingType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
