package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidRequiredPasswordComplexity implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("low")
    LOW("low", "1"),

    @JsonProperty("medium")
    MEDIUM("medium", "2"),

    @JsonProperty("high")
    HIGH("high", "3");

    private final String name;
    private final String value;

    private AndroidRequiredPasswordComplexity(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
