package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidProfileApplicability implements Enum {

    @JsonProperty("default")
    DEFAULT("default", "0"),

    @JsonProperty("androidWorkProfile")
    ANDROID_WORK_PROFILE("androidWorkProfile", "1"),

    @JsonProperty("androidDeviceOwner")
    ANDROID_DEVICE_OWNER("androidDeviceOwner", "2");

    private final String name;
    private final String value;

    private AndroidProfileApplicability(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
