package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidPermissionActionType implements Enum {

    @JsonProperty("prompt")
    PROMPT("prompt", "0"),

    @JsonProperty("autoGrant")
    AUTO_GRANT("autoGrant", "1"),

    @JsonProperty("autoDeny")
    AUTO_DENY("autoDeny", "2");

    private final String name;
    private final String value;

    private AndroidPermissionActionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
