package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidManagedAppSafetyNetDeviceAttestationType implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("basicIntegrity")
    BASIC_INTEGRITY("basicIntegrity", "1"),

    @JsonProperty("basicIntegrityAndDeviceCertification")
    BASIC_INTEGRITY_AND_DEVICE_CERTIFICATION("basicIntegrityAndDeviceCertification", "2");

    private final String name;
    private final String value;

    private AndroidManagedAppSafetyNetDeviceAttestationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
