package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidKeyguardFeature implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("camera")
    CAMERA("camera", "1"),

    @JsonProperty("notifications")
    NOTIFICATIONS("notifications", "2"),

    @JsonProperty("unredactedNotifications")
    UNREDACTED_NOTIFICATIONS("unredactedNotifications", "3"),

    @JsonProperty("trustAgents")
    TRUST_AGENTS("trustAgents", "4"),

    @JsonProperty("fingerprint")
    FINGERPRINT("fingerprint", "5"),

    @JsonProperty("remoteInput")
    REMOTE_INPUT("remoteInput", "6"),

    @JsonProperty("allFeatures")
    ALL_FEATURES("allFeatures", "7");

    private final String name;
    private final String value;

    private AndroidKeyguardFeature(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
