package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidForWorkBindStatus implements Enum {

    @JsonProperty("notBound")
    NOT_BOUND("notBound", "0"),

    @JsonProperty("bound")
    BOUND("bound", "1"),

    @JsonProperty("boundAndValidated")
    BOUND_AND_VALIDATED("boundAndValidated", "2"),

    @JsonProperty("unbinding")
    UNBINDING("unbinding", "3");

    private final String name;
    private final String value;

    private AndroidForWorkBindStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
