package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidDeviceOwnerPlayStoreMode implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("allowList")
    ALLOW_LIST("allowList", "1"),

    @JsonProperty("blockList")
    BLOCK_LIST("blockList", "2");

    private final String name;
    private final String value;

    private AndroidDeviceOwnerPlayStoreMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
