package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidDeviceOwnerKioskCustomizationStatusBar implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("notificationsAndSystemInfoEnabled")
    NOTIFICATIONS_AND_SYSTEM_INFO_ENABLED("notificationsAndSystemInfoEnabled", "1"),

    @JsonProperty("systemInfoOnly")
    SYSTEM_INFO_ONLY("systemInfoOnly", "2");

    private final String name;
    private final String value;

    private AndroidDeviceOwnerKioskCustomizationStatusBar(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
