package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidDeviceOwnerCrossProfileDataSharing implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("crossProfileDataSharingBlocked")
    CROSS_PROFILE_DATA_SHARING_BLOCKED("crossProfileDataSharingBlocked", "1"),

    @JsonProperty("dataSharingFromWorkToPersonalBlocked")
    DATA_SHARING_FROM_WORK_TO_PERSONAL_BLOCKED("dataSharingFromWorkToPersonalBlocked", "2"),

    @JsonProperty("crossProfileDataSharingAllowed")
    CROSS_PROFILE_DATA_SHARING_ALLOWED("crossProfileDataSharingAllowed", "3"),

    @JsonProperty("unkownFutureValue")
    UNKOWN_FUTURE_VALUE("unkownFutureValue", "4");

    private final String name;
    private final String value;

    private AndroidDeviceOwnerCrossProfileDataSharing(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
