package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AnalyticsActivityType implements Enum {

    @JsonProperty("Email")
    EMAIL("Email", "0"),

    @JsonProperty("Meeting")
    MEETING("Meeting", "1"),

    @JsonProperty("Focus")
    FOCUS("Focus", "2"),

    @JsonProperty("Chat")
    CHAT("Chat", "3"),

    @JsonProperty("Call")
    CALL("Call", "4");

    private final String name;
    private final String value;

    private AnalyticsActivityType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
