package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AllowedAudiences implements Enum {

    @JsonProperty("me")
    ME("me", "0"),

    @JsonProperty("family")
    FAMILY("family", "1"),

    @JsonProperty("contacts")
    CONTACTS("contacts", "2"),

    @JsonProperty("groupMembers")
    GROUP_MEMBERS("groupMembers", "4"),

    @JsonProperty("organization")
    ORGANIZATION("organization", "8"),

    @JsonProperty("federatedOrganizations")
    FEDERATED_ORGANIZATIONS("federatedOrganizations", "16"),

    @JsonProperty("everyone")
    EVERYONE("everyone", "32"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "64");

    private final String name;
    private final String value;

    private AllowedAudiences(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
