package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AllowInvitesFrom implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("adminsAndGuestInviters")
    ADMINS_AND_GUEST_INVITERS("adminsAndGuestInviters", "1"),

    @JsonProperty("adminsGuestInvitersAndAllMembers")
    ADMINS_GUEST_INVITERS_AND_ALL_MEMBERS("adminsGuestInvitersAndAllMembers", "2"),

    @JsonProperty("everyone")
    EVERYONE("everyone", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private AllowInvitesFrom(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
